<?php
header('Content-Type: application/json');
require 'dbcon.php'; // your PDO connection

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['emailOrPhone']) || !isset($data['pin'])) {
        echo json_encode(['success' => false, 'message' => 'Missing parameters']);
        exit;
    }

    $emailOrPhone = $data['emailOrPhone'];
    $pin = $data['pin'];

    // Fetch the hashed PIN from DB
    $stmt = $pdo->prepare("SELECT login_pin FROM users WHERE email = :emailOrPhone OR phone = :emailOrPhone LIMIT 1");
    $stmt->execute(['emailOrPhone' => $emailOrPhone]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user || !$user['login_pin']) {
        echo json_encode(['success' => false, 'message' => 'No PIN set for this user']);
        exit;
    }

    // Verify the PIN
    if (password_verify($pin, $user['login_pin'])) {
        echo json_encode(['success' => true, 'message' => 'PIN verified successfully']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Incorrect PIN']);
    }

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
 ?>