<?php

header('Content-Type: application/json');
require 'dbcon.php'; // your PDO connection file

try {

	$rawData = file_get_contents("php://input");
	file_put_contents("log.txt", $rawData . PHP_EOL, FILE_APPEND);

  $data = json_decode(file_get_contents("php://input"), true);
	//echo $data['emailOrPhone'];  
  if (!isset($data['emailOrPhone']) || !isset($data['pin'])) {
    echo json_encode(['success' => false, 'message' => 'Missing parameters']);
    exit;
  }

  $emailOrPhone = $data['emailOrPhone'];
  
  $pin = password_hash($data['pin'], PASSWORD_BCRYPT); // hash pin securely
  

  $stmt = $pdo->prepare("UPDATE users SET login_pin = :pin WHERE email = :emailOrPhone || phone=:emailOrPhone");
  $stmt->execute(['pin' => $pin, 'emailOrPhone' => $emailOrPhone]);

  if ($stmt->rowCount() > 0) {
    echo json_encode(['success' => true, 'message' => 'PIN updated successfully']);
  } else {
    echo json_encode(['success' => false, 'message' => 'No record updated']);
  }
} catch (Exception $e) {
  echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>